###### Preço Total Anual  ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa função tem como argumentos: produto e grupo. 
# produto = (tora, acabado)
# grupo = (geral, grupo1, grupo2, grupo3)

# Carrega pacotes a serem utilizados
    library(data.table)
    library(dplyr)
    library(tidyr)
    library(ggplot2)
    #library(scater) # para a funcao multiplot

    #  Lê sisdof_tora
    sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                         colClasses = c("character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "numeric", "numeric"))
    
    # Deleta coluna V1 criada pelo comando fread.
    sisdof_tora$V1 <- NULL
    
    # Lê sisdof_produto
    sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                            colClasses = c("character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "numeric", "numeric"))
    
    # Deleta coluna V1 criada pelo comando fread.
    sisdof_produto$V1 <- NULL

preco_total_anual <- function (produto, grupo) {
    # produto = (tora, acabado)
    
    # grupo = (geral, grupo1, grupo2, grupo3)
    # geral = todas as espécies
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    # Função para passar apenas a primeira letra de uma palavra para maiúscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Títulos do gráfico
    titulo <- capFirst(grupo)
    
    if (produto == "tora") {
        
        # Muda diretório de trabalho para o de Toras. Cria o diretorio se ja nao existir.
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.1.Toras", 
                                     "1.1.6.Preco.Total")),
               dir.create(file.path("Figuras",
                                    "1.1.Toras",
                                    "1.1.6.Preco.Total"),
                          recursive = TRUE,
                          showWarnings = FALSE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.1.Toras", 
                        "1.1.6.Preco.Total"))
        
        # sisdof =  sisdof_tora
        sisdof <- sisdof_tora
        
        # Nome no eixo y dos gráficos a serem gerados
        nome <- "toras e toretes movimentados"
        
        } else if (produto == "acabado") {
            
            # Muda diretório de trabalho para o de Toras. Cria o diretorio se ja nao existir.
            
            ifelse(!dir.exists(file.path("Figuras", 
                                         "1.2.Produto.Acabado", 
                                         "1.2.6.Preco.Total")),
                   dir.create(file.path("Figuras", 
                                        "1.2.Produto.Acabado", 
                                        "1.2.6.Preco.Total"),
                              recursive = TRUE,
                              showWarnings = FALSE),
                   FALSE)
            
            setwd(file.path("Figuras", 
                            "1.2.Produto.Acabado", 
                            "1.2.6.Preco.Total"))
            
            # sisdof = sisdof_produto
            sisdof <- sisdof_produto
        
            # Nome no eixo y dos gráficos a serem gerados
            nome <- "produtos madeireiros movimentados"
            
            } 
    
    if (grupo == "grupo1") {
            
            lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espécies contidas no grupo 1
           
            } else if (grupo == "grupo2") {
                
                lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espécies contidas no grupo 2
                
                } else if (grupo == "grupo3") {
                    
                    lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espécies contidas no grupo 3
                    
                }
    
    y <- sisdof
    
    # Elimina o mês, mantendo apenas o ano
    y$Emissao <- as.numeric(sub("^[0-9]+-", "", y$Emissao))
    
    y <- y[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                  by = .(Especie, 
                         Emissao,
                         Portaria.443,
                         Cites)]
    
    # Renomeia as colunas V1 e V2  
    y <- dplyr::rename(y,
                              "Volume.Total" = "V1",
                              "Preco.Total" = "V2")
    
    nomes.443 <- unique(y$Especie[!is.na(y$Portaria.443)])
    
    nomes.cites <- unique(y$Especie[!is.na(y$Cites)])
    
    ## Cria o subset geral
    geral <- y
    
    # Cria a coluna Categoria para agrupar os graficos
    geral$Categoria <- "Todas as espécies"
    
    # Agrega
    geral <- geral[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                       by = .(Emissao,
                              Categoria)]
    
    # Renomeia as colunas V1 e V2  
    geral <- dplyr::rename(geral,
                       "Volume.Total" = "V1",
                       "Preco.Total" = "V2")
    
    ## Cria o subset Portaria 443
    agregado443 <- y[!is.na(y$Portaria.443)]
    
    # Cria a coluna Categoria
    agregado443$Categoria <- "Espécies ameaçadas de extinção"
    
    # Agrega
    agregado443 <- agregado443[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                               by = .(Emissao,
                                      Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregado443 <- dplyr::rename(agregado443,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    ## Cria o subset Cites
    agregadocites <- y[!is.na(y$Cites)]
    
    # Cria a coluna Categoria
    agregadocites$Categoria <- "Espécies CITES"
    
    # Agrega
    agregadocites <- agregadocites[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                               by = .(Emissao,
                                      Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregadocites <- dplyr::rename(agregadocites,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    ## Faz o gráfico das especies
    
    if (grupo == "geral") {
        
        lista_especies <- "Todas as espécies"
    
        especie <- rbind(geral, agregado443, agregadocites)
        
        especie$Categoria <- factor(especie$Categoria, 
                                    levels = c("Todas as espécies",
                                               "Espécies ameaçadas de extinção",
                                               "Espécies CITES"))
        
        # Ordena de forma crescente em relação a data
        especie <- especie[order(especie$Emissao),]
        
        # Cria a coluna Volume.Relativo, em funcao do volume de 2012
        # especie$Volume.Relativo <- especie$Volume.Total/especie$Volume.Total[especie$Emissao == "2012"]
        
        gplot <- ggplot(especie, aes(x = Emissao, 
                                     y = Preco.Total/1000000,
                                     colour = factor(Categoria)))+
            facet_wrap(~ Categoria, nrow = 2, scales = "free_y")+
            geom_point() +                                                  # adiciona os pontos no gráfico
            #geom_line() +                                                  # adiciona uma linha reta ligando cada um dos pontos do gráfico
            geom_smooth(method = "loess")+                                  # adiciona uma reta curva conforme os pontos do gráficos.
            geom_label(data = especie,                                      # adiciona uma caixa de texto com os valores de y do gráfico
                       aes(label = format(round(Volume.Total/1000, 2))),    # indica que o texto da caixa de texto serão os valores do Volume.Total/1000, mostrando apenas duas casas decimais
                       vjust = "inward",                                    # alinhamento vertical da caixa de texto
                       hjust = "inward",                                    # alinhamento horizontal da caixa de texto
                       size = 4,                                            # tamanho do texto da caixa de texto 
                       label.size = 0.1)+                                   # tamanho da borda da caixa de texto 
            theme(strip.text.x = element_text(size = 14),                   # tamanho do titulo de cada um dos graficos do facet_wrap
                  axis.title.x = element_text(size = 14),                   # tamanho dos titulo do eixo x ("Ano")
                  axis.text.x = element_text(size = 12),                    # tamanho dos valores do eixo x (2012, 2013...)
                  axis.title.y = element_text(size = 14),                   # tamanho do titulo do eixo y
                  axis.text.y = element_blank(),                            # elimina o texto dos valores do eixo y (volume movimentado). Esses valores estarao na caixa de texto
                  axis.ticks.y = element_blank(),                           # elimina os marcos (ticks) do eixo y
                  legend.position = "none",                                 # elimina a legenda
                  plot.title = element_text(lineheight=.8,                  # formata o titulo do grafico
                                            face="bold",
                                            hjust=0.5,
                                            size = 18),
                  panel.grid.minor = element_blank())+                      # elimina os grids menores
            ylab(paste("Valor de", 
                       nome, 
                       "(x 10^6 R$)", 
                       sep = " ")) +
            xlab("Ano") +
            ggtitle(paste("Valor movimentado (x 10^6 R$)", 
                        titulo, "2012 a 2017", sep = " - "))+
            scale_color_brewer(palette = "Dark2")                           # usa a paleta de cores "Dark2" do pacote RColorBrewer
        
        # Abre para gravacao em PDF
          pdf(paste0("#", 
                     titulo, 
                     "_Preco_Anual.pdf"), 
              width = 8, 
              height = 6.5)
        
        print(gplot)
        
        # Fecha o PDF
        dev.off()
        
    } else if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            especie <- y[y$Especie == lista_especies[i]]
            
            # Renomeia a coluna Especie para Categoria
            especie <- dplyr::rename(especie,
                                     "Categoria" = "Especie")
            
            # Deleta as colunas Portaria.443 e Cites de especie
            especie <- especie[, -(Portaria.443:Cites)]
            
            # Fusiona especie e geral
            especie <- rbind(especie, geral)
            
            if (grupo == "grupo1") {
                
                especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies"))
               
                 if (lista_especies[i] %in% nomes.443) {
                     
                     especie <- rbind(especie, agregado443)
                     
                     especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies ameaçadas de extinção"))
                     
                     } 
                
                if (lista_especies[i] %in% nomes.cites) {
                    
                    especie <- rbind(especie, agregadocites)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies CITES"))
                    
                    if (lista_especies[i] %in% nomes.443) {
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                    levels = c(lista_especies[i],
                                                               "Todas as espécies",
                                                               "Espécies ameaçadas de extinção",
                                                               "Espécies CITES"))
                        
                    } 
                    
                    
                }
                
                } else if (grupo == "grupo2") {
                    
                    especie <- rbind(especie, agregado443)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies ameaçadas de extinção"))
                    
                    if (lista_especies[i] %in% nomes.cites) {
                        
                        especie <- rbind(especie, agregadocites)
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies ameaçadas de extinção",
                                                           "Espécies CITES"))
                }
                
                } else if (grupo == "grupo3") {
                    
                    especie <- rbind(especie, agregadocites)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies CITES"))
                    
                    if (lista_especies[i] %in% nomes.443) {
                        
                        especie <- rbind(especie, agregado443)
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies CITES",
                                                           "Espécies ameaçadas de extinção"))
                        
                    }
                    
                    }
           
                
            # Ordena de forma crescente em relação a data
            especie <- especie[order(especie$Emissao),]
            
            # Cria a coluna Volume.Relativo, em funcao do volume de 2012
            # especie$Volume.Relativo <- especie$Volume.Total/especie$Volume.Total[especie$Emissao == "2012"]
            
          
            # Gera o grafico
            gplot <- ggplot(especie, aes(x = Emissao, 
                                         y = Preco.Total/1000000,
                                         colour = factor(Categoria))) +
                facet_wrap(~ Categoria, nrow = 2, scales = "free_y")+
                geom_point() +                                                  # adiciona os pontos no gráfico
                #geom_line() +                                                  # adiciona uma linha reta ligando cada um dos pontos do gráfico
                geom_smooth(method = "loess")+                                  # adiciona uma reta curva conforme os pontos do gráficos.
                geom_label(data = especie,                                      # adiciona uma caixa de texto com os valores de y do gráfico
                           aes(label = format(round(Volume.Total/1000, 2))),    # indica que o texto da caixa de texto serão os valores do Volume.Total/1000, mostrando apenas duas casas decimais
                           vjust = "inward",                                    # alinhamento vertical da caixa de texto
                           hjust = "inward",                                    # alinhamento horizontal da caixa de texto
                           size = 4,                                            # tamanho do texto da caixa de texto 
                           label.size = 0.1)+                                   # tamanho da borda da caixa de texto 
                theme(strip.text.x = element_text(size = 14),                   # tamanho do titulo de cada um dos graficos do facet_wrap
                      axis.title.x = element_text(size = 14),                   # tamanho dos titulo do eixo x ("Ano")
                      axis.text.x = element_text(size = 12),                    # tamanho dos valores do eixo x (2012, 2013...)
                      axis.title.y = element_text(size = 14),                   # tamanho do titulo do eixo y
                      axis.text.y = element_blank(),                            # elimina o texto dos valores do eixo y (volume movimentado). Esses valores estarao na caixa de texto
                      axis.ticks.y = element_blank(),                           # elimina os marcos (ticks) do eixo y
                      legend.position = "none",                                 # elimina a legenda
                      plot.title = element_text(lineheight=.8,                  # formata o titulo do grafico
                                                face="bold",
                                                hjust=0.5,
                                                size = 18),
                      panel.grid.minor = element_blank())+                      # elimina os grids menores
                ylab(paste("Valor de", nome, "(x 10^6 R$)", sep = " ")) +
                xlab("Ano") +
                ggtitle(paste("Valor movimentado (x 10^6 R$)", 
                            lista_especies[i], "2012 a 2017", sep = " - "))+
                scale_color_brewer(palette = "Dark2")                           # usa a paleta de cores "Dark2" do pacote RColorBrewer
            
            # Abre para gravacao em PDF
            pdf(paste0(titulo, 
                       "_", 
                       lista_especies[i], 
                       "_Preco_Anual.pdf"), 
                width = 8, 
                height = 6.5)
            
            print(gplot)
            
            # Fecha o PDF
            dev.off()
        }
    
   
    
        }
    

# Sobe para o diretorio raiz do script    
  setwd("..")
  setwd("..")
  setwd("..")

}

preco_total_anual("tora", "geral")
preco_total_anual("tora", "grupo1")
preco_total_anual("tora", "grupo2")
preco_total_anual("tora", "grupo3")

preco_total_anual("acabado", "geral")
preco_total_anual("acabado", "grupo1")
preco_total_anual("acabado", "grupo2")
preco_total_anual("acabado", "grupo3")

    
    
    

   
    
    